/*
 * Decompiled with CFR 0.152.
 */
package com.andavin.images.v1_17_R1;

import com.andavin.reflect.Reflection;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.core.BlockPosition;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketPlayOutEntityDestroy;
import net.minecraft.network.protocol.game.PacketPlayOutEntityMetadata;
import net.minecraft.network.protocol.game.PacketPlayOutMap;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.server.network.PlayerConnection;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.decoration.EntityItemFrame;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.IMaterial;
import net.minecraft.world.level.World;
import net.minecraft.world.level.saveddata.maps.WorldMap;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.block.BlockFace;
import org.bukkit.craftbukkit.v1_17_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_17_R1.block.CraftBlock;
import org.bukkit.craftbukkit.v1_17_R1.entity.CraftPlayer;
import org.bukkit.entity.Player;
import org.bukkit.map.MapPalette;
import org.bukkit.map.MapView;

class MapHelper
extends com.andavin.images.MapHelper {
    static final int DEFAULT_STARTING_ID = 1000000;
    private static final Field ENTITY_ID = Reflection.findField(Entity.class, "as");
    private static final DataWatcherObject<Integer> ROTATION = (DataWatcherObject)Reflection.getFieldValue(EntityItemFrame.class, null, "ap");
    private static final Map<UUID, AtomicInteger> MAP_IDS = new HashMap<UUID, AtomicInteger>(4);

    MapHelper() {
    }

    @Override
    protected MapView getWorldMap(int id) {
        return Bukkit.getMap((int)id);
    }

    @Override
    protected int nextMapId(org.bukkit.World world) {
        return MAP_IDS.computeIfAbsent(world.getUID(), __ -> new AtomicInteger(1000000)).getAndIncrement();
    }

    @Override
    protected void createMap(int frameId, int mapId, Player player, Location location, BlockFace direction, int rotation, byte[] pixels) {
        ItemStack item = new ItemStack((IMaterial)Items.pp);
        item.getOrCreateTag().setInt("map", mapId);
        EntityItemFrame frame = new EntityItemFrame((World)((CraftWorld)player.getWorld()).getHandle(), new BlockPosition(location.getX(), location.getY(), location.getZ()), CraftBlock.blockFaceToNotch((BlockFace)direction));
        frame.setItem(item, false, false);
        frame.setInvisible(invisible);
        Reflection.setFieldValue(ENTITY_ID, frame, frameId);
        if (rotation != 0) {
            frame.getDataWatcher().set(ROTATION, (Object)rotation);
        }
        PlayerConnection connection = ((CraftPlayer)player).getHandle().b;
        connection.sendPacket((Packet)new PacketPlayOutSpawnEntity((Entity)frame, EntityTypes.R, frame.getDirection().b(), frame.getBlockPosition()));
        connection.sendPacket((Packet)new PacketPlayOutEntityMetadata(frame.getId(), frame.getDataWatcher(), true));
        connection.sendPacket((Packet)new PacketPlayOutMap(mapId, 3, false, Collections.emptyList(), new WorldMap.b(0, 0, 128, 128, pixels)));
    }

    @Override
    protected void destroyMap(Player player, int[] frameIds) {
        ((CraftPlayer)player).getHandle().b.sendPacket((Packet)new PacketPlayOutEntityDestroy(frameIds));
    }

    @Override
    protected byte[] createPixels(BufferedImage image) {
        int pixelCount = image.getWidth() * image.getHeight();
        int[] pixels = new int[pixelCount];
        image.getRGB(0, 0, image.getWidth(), image.getHeight(), pixels, 0, image.getWidth());
        byte[] colors = new byte[pixelCount];
        for (int i = 0; i < pixelCount; ++i) {
            colors[i] = MapPalette.matchColor((Color)new Color(pixels[i], true));
        }
        return colors;
    }
}

